<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vision;

class Image extends \Google\Model
{
  /**
   * Image content, represented as a stream of bytes. Note: As with all `bytes`
   * fields, protobuffers use a pure binary representation, whereas JSON
   * representations use base64. Currently, this field only works for
   * BatchAnnotateImages requests. It does not work for AsyncBatchAnnotateImages
   * requests.
   *
   * @var string
   */
  public $content;
  protected $sourceType = ImageSource::class;
  protected $sourceDataType = '';

  /**
   * Image content, represented as a stream of bytes. Note: As with all `bytes`
   * fields, protobuffers use a pure binary representation, whereas JSON
   * representations use base64. Currently, this field only works for
   * BatchAnnotateImages requests. It does not work for AsyncBatchAnnotateImages
   * requests.
   *
   * @param string $content
   */
  public function setContent($content)
  {
    $this->content = $content;
  }
  /**
   * @return string
   */
  public function getContent()
  {
    return $this->content;
  }
  /**
   * Google Cloud Storage image location, or publicly-accessible image URL. If
   * both `content` and `source` are provided for an image, `content` takes
   * precedence and is used to perform the image annotation request.
   *
   * @param ImageSource $source
   */
  public function setSource(ImageSource $source)
  {
    $this->source = $source;
  }
  /**
   * @return ImageSource
   */
  public function getSource()
  {
    return $this->source;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Image::class, 'Google_Service_Vision_Image');
