<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class ConversionSource extends \Google\Model
{
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * Conversion source is fully functional.
   */
  public const STATE_ACTIVE = 'ACTIVE';
  /**
   * Conversion source has been archived in the last 30 days and not currently
   * functional. Can be restored using the undelete method.
   */
  public const STATE_ARCHIVED = 'ARCHIVED';
  /**
   * Conversion source creation has started but not fully finished yet.
   */
  public const STATE_PENDING = 'PENDING';
  /**
   * Output only. Generated by the Content API upon creation of a new
   * `ConversionSource`. Format: [a-z]{4}:.+ The four characters before the
   * colon represent the type of conversio source. Content after the colon
   * represents the ID of the conversion source within that type. The ID of two
   * different conversion sources might be the same across different types. The
   * following type prefixes are supported: - galk: For GoogleAnalyticsLink
   * sources. - mcdn: For MerchantCenterDestination sources.
   *
   * @var string
   */
  public $conversionSourceId;
  /**
   * Output only. The time when an archived conversion source becomes
   * permanently deleted and is no longer available to undelete.
   *
   * @var string
   */
  public $expireTime;
  protected $googleAnalyticsLinkType = GoogleAnalyticsLink::class;
  protected $googleAnalyticsLinkDataType = '';
  protected $merchantCenterDestinationType = MerchantCenterDestination::class;
  protected $merchantCenterDestinationDataType = '';
  /**
   * Output only. Current state of this conversion source. Can't be edited
   * through the API.
   *
   * @var string
   */
  public $state;

  /**
   * Output only. Generated by the Content API upon creation of a new
   * `ConversionSource`. Format: [a-z]{4}:.+ The four characters before the
   * colon represent the type of conversio source. Content after the colon
   * represents the ID of the conversion source within that type. The ID of two
   * different conversion sources might be the same across different types. The
   * following type prefixes are supported: - galk: For GoogleAnalyticsLink
   * sources. - mcdn: For MerchantCenterDestination sources.
   *
   * @param string $conversionSourceId
   */
  public function setConversionSourceId($conversionSourceId)
  {
    $this->conversionSourceId = $conversionSourceId;
  }
  /**
   * @return string
   */
  public function getConversionSourceId()
  {
    return $this->conversionSourceId;
  }
  /**
   * Output only. The time when an archived conversion source becomes
   * permanently deleted and is no longer available to undelete.
   *
   * @param string $expireTime
   */
  public function setExpireTime($expireTime)
  {
    $this->expireTime = $expireTime;
  }
  /**
   * @return string
   */
  public function getExpireTime()
  {
    return $this->expireTime;
  }
  /**
   * Immutable. Conversion Source of type "Link to Google Analytics Property".
   *
   * @param GoogleAnalyticsLink $googleAnalyticsLink
   */
  public function setGoogleAnalyticsLink(GoogleAnalyticsLink $googleAnalyticsLink)
  {
    $this->googleAnalyticsLink = $googleAnalyticsLink;
  }
  /**
   * @return GoogleAnalyticsLink
   */
  public function getGoogleAnalyticsLink()
  {
    return $this->googleAnalyticsLink;
  }
  /**
   * Conversion Source of type "Merchant Center Tag Destination".
   *
   * @param MerchantCenterDestination $merchantCenterDestination
   */
  public function setMerchantCenterDestination(MerchantCenterDestination $merchantCenterDestination)
  {
    $this->merchantCenterDestination = $merchantCenterDestination;
  }
  /**
   * @return MerchantCenterDestination
   */
  public function getMerchantCenterDestination()
  {
    return $this->merchantCenterDestination;
  }
  /**
   * Output only. Current state of this conversion source. Can't be edited
   * through the API.
   *
   * Accepted values: STATE_UNSPECIFIED, ACTIVE, ARCHIVED, PENDING
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ConversionSource::class, 'Google_Service_ShoppingContent_ConversionSource');
