<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ServiceNetworking;

class BillingDestination extends \Google\Collection
{
  protected $collection_key = 'metrics';
  /**
   * Names of the metrics to report to this billing destination. Each name must
   * be defined in Service.metrics section.
   *
   * @var string[]
   */
  public $metrics;
  /**
   * The monitored resource type. The type must be defined in
   * Service.monitored_resources section.
   *
   * @var string
   */
  public $monitoredResource;

  /**
   * Names of the metrics to report to this billing destination. Each name must
   * be defined in Service.metrics section.
   *
   * @param string[] $metrics
   */
  public function setMetrics($metrics)
  {
    $this->metrics = $metrics;
  }
  /**
   * @return string[]
   */
  public function getMetrics()
  {
    return $this->metrics;
  }
  /**
   * The monitored resource type. The type must be defined in
   * Service.monitored_resources section.
   *
   * @param string $monitoredResource
   */
  public function setMonitoredResource($monitoredResource)
  {
    $this->monitoredResource = $monitoredResource;
  }
  /**
   * @return string
   */
  public function getMonitoredResource()
  {
    return $this->monitoredResource;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BillingDestination::class, 'Google_Service_ServiceNetworking_BillingDestination');
