<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SecurityCommandCenter;

class GoogleCloudSecuritycenterV2ExfilResource extends \Google\Collection
{
  protected $collection_key = 'components';
  /**
   * Subcomponents of the asset that was exfiltrated, like URIs used during
   * exfiltration, table names, databases, and filenames. For example, multiple
   * tables might have been exfiltrated from the same Cloud SQL instance, or
   * multiple files might have been exfiltrated from the same Cloud Storage
   * bucket.
   *
   * @var string[]
   */
  public $components;
  /**
   * The resource's [full resource name](https://cloud.google.com/apis/design/re
   * source_names#full_resource_name).
   *
   * @var string
   */
  public $name;

  /**
   * Subcomponents of the asset that was exfiltrated, like URIs used during
   * exfiltration, table names, databases, and filenames. For example, multiple
   * tables might have been exfiltrated from the same Cloud SQL instance, or
   * multiple files might have been exfiltrated from the same Cloud Storage
   * bucket.
   *
   * @param string[] $components
   */
  public function setComponents($components)
  {
    $this->components = $components;
  }
  /**
   * @return string[]
   */
  public function getComponents()
  {
    return $this->components;
  }
  /**
   * The resource's [full resource name](https://cloud.google.com/apis/design/re
   * source_names#full_resource_name).
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudSecuritycenterV2ExfilResource::class, 'Google_Service_SecurityCommandCenter_GoogleCloudSecuritycenterV2ExfilResource');
