<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Reports;

class Activities extends \Google\Collection
{
  protected $collection_key = 'items';
  /**
   * ETag of the resource.
   *
   * @var string
   */
  public $etag;
  protected $itemsType = Activity::class;
  protected $itemsDataType = 'array';
  /**
   * The type of API resource. For an activity report, the value is
   * `reports#activities`.
   *
   * @var string
   */
  public $kind;
  /**
   * Token for retrieving the follow-on next page of the report. The
   * `nextPageToken` value is used in the request's `pageToken` query string.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * ETag of the resource.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Each activity record in the response.
   *
   * @param Activity[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return Activity[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * The type of API resource. For an activity report, the value is
   * `reports#activities`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Token for retrieving the follow-on next page of the report. The
   * `nextPageToken` value is used in the request's `pageToken` query string.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Activities::class, 'Google_Service_Reports_Activities');
