<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\PubsubLite;

class ComputeMessageStatsRequest extends \Google\Model
{
  protected $endCursorType = Cursor::class;
  protected $endCursorDataType = '';
  /**
   * Required. The partition for which we should compute message stats.
   *
   * @var string
   */
  public $partition;
  protected $startCursorType = Cursor::class;
  protected $startCursorDataType = '';

  /**
   * The exclusive end of the range. The range is empty if end_cursor <=
   * start_cursor. Specifying a start_cursor before the first message and an
   * end_cursor after the last message will retrieve all messages.
   *
   * @param Cursor $endCursor
   */
  public function setEndCursor(Cursor $endCursor)
  {
    $this->endCursor = $endCursor;
  }
  /**
   * @return Cursor
   */
  public function getEndCursor()
  {
    return $this->endCursor;
  }
  /**
   * Required. The partition for which we should compute message stats.
   *
   * @param string $partition
   */
  public function setPartition($partition)
  {
    $this->partition = $partition;
  }
  /**
   * @return string
   */
  public function getPartition()
  {
    return $this->partition;
  }
  /**
   * The inclusive start of the range.
   *
   * @param Cursor $startCursor
   */
  public function setStartCursor(Cursor $startCursor)
  {
    $this->startCursor = $startCursor;
  }
  /**
   * @return Cursor
   */
  public function getStartCursor()
  {
    return $this->startCursor;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ComputeMessageStatsRequest::class, 'Google_Service_PubsubLite_ComputeMessageStatsRequest');
