<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\PublicCertificateAuthority;

class ExternalAccountKey extends \Google\Model
{
  /**
   * Output only. Base64-URL-encoded HS256 key. It is generated by the
   * PublicCertificateAuthorityService when the ExternalAccountKey is created
   *
   * @var string
   */
  public $b64MacKey;
  /**
   * Output only. Key ID. It is generated by the
   * PublicCertificateAuthorityService when the ExternalAccountKey is created
   *
   * @var string
   */
  public $keyId;
  /**
   * Output only. Resource name.
   * projects/{project}/locations/{location}/externalAccountKeys/{key_id}
   *
   * @var string
   */
  public $name;

  /**
   * Output only. Base64-URL-encoded HS256 key. It is generated by the
   * PublicCertificateAuthorityService when the ExternalAccountKey is created
   *
   * @param string $b64MacKey
   */
  public function setB64MacKey($b64MacKey)
  {
    $this->b64MacKey = $b64MacKey;
  }
  /**
   * @return string
   */
  public function getB64MacKey()
  {
    return $this->b64MacKey;
  }
  /**
   * Output only. Key ID. It is generated by the
   * PublicCertificateAuthorityService when the ExternalAccountKey is created
   *
   * @param string $keyId
   */
  public function setKeyId($keyId)
  {
    $this->keyId = $keyId;
  }
  /**
   * @return string
   */
  public function getKeyId()
  {
    return $this->keyId;
  }
  /**
   * Output only. Resource name.
   * projects/{project}/locations/{location}/externalAccountKeys/{key_id}
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ExternalAccountKey::class, 'Google_Service_PublicCertificateAuthority_ExternalAccountKey');
