<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudConnectorsV1AuthConfigOauth2ClientCredentials extends \Google\Model
{
  /**
   * Optional. The client identifier.
   *
   * @var string
   */
  public $clientId;
  protected $clientSecretType = GoogleCloudConnectorsV1Secret::class;
  protected $clientSecretDataType = '';

  /**
   * Optional. The client identifier.
   *
   * @param string $clientId
   */
  public function setClientId($clientId)
  {
    $this->clientId = $clientId;
  }
  /**
   * @return string
   */
  public function getClientId()
  {
    return $this->clientId;
  }
  /**
   * Optional. Secret version reference containing the client secret.
   *
   * @param GoogleCloudConnectorsV1Secret $clientSecret
   */
  public function setClientSecret(GoogleCloudConnectorsV1Secret $clientSecret)
  {
    $this->clientSecret = $clientSecret;
  }
  /**
   * @return GoogleCloudConnectorsV1Secret
   */
  public function getClientSecret()
  {
    return $this->clientSecret;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudConnectorsV1AuthConfigOauth2ClientCredentials::class, 'Google_Service_Integrations_GoogleCloudConnectorsV1AuthConfigOauth2ClientCredentials');
