<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ContainerAnalysis;

class Command extends \Google\Collection
{
  protected $collection_key = 'waitFor';
  /**
   * Command-line arguments used when executing this command.
   *
   * @var string[]
   */
  public $args;
  /**
   * Working directory (relative to project source root) used when running this
   * command.
   *
   * @var string
   */
  public $dir;
  /**
   * Environment variables set before running this command.
   *
   * @var string[]
   */
  public $env;
  /**
   * Optional unique identifier for this command, used in wait_for to reference
   * this command as a dependency.
   *
   * @var string
   */
  public $id;
  /**
   * Required. Name of the command, as presented on the command line, or if the
   * command is packaged as a Docker container, as presented to `docker pull`.
   *
   * @var string
   */
  public $name;
  /**
   * The ID(s) of the command(s) that this command depends on.
   *
   * @var string[]
   */
  public $waitFor;

  /**
   * Command-line arguments used when executing this command.
   *
   * @param string[] $args
   */
  public function setArgs($args)
  {
    $this->args = $args;
  }
  /**
   * @return string[]
   */
  public function getArgs()
  {
    return $this->args;
  }
  /**
   * Working directory (relative to project source root) used when running this
   * command.
   *
   * @param string $dir
   */
  public function setDir($dir)
  {
    $this->dir = $dir;
  }
  /**
   * @return string
   */
  public function getDir()
  {
    return $this->dir;
  }
  /**
   * Environment variables set before running this command.
   *
   * @param string[] $env
   */
  public function setEnv($env)
  {
    $this->env = $env;
  }
  /**
   * @return string[]
   */
  public function getEnv()
  {
    return $this->env;
  }
  /**
   * Optional unique identifier for this command, used in wait_for to reference
   * this command as a dependency.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Required. Name of the command, as presented on the command line, or if the
   * command is packaged as a Docker container, as presented to `docker pull`.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The ID(s) of the command(s) that this command depends on.
   *
   * @param string[] $waitFor
   */
  public function setWaitFor($waitFor)
  {
    $this->waitFor = $waitFor;
  }
  /**
   * @return string[]
   */
  public function getWaitFor()
  {
    return $this->waitFor;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Command::class, 'Google_Service_ContainerAnalysis_Command');
