<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudHealthcare;

class RollbackHl7V2MessagesResponse extends \Google\Model
{
  /**
   * The name of the HL7v2 store to rollback, in the format of
   * "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
   * /hl7v2Stores/{hl7v2_store_id}".
   *
   * @var string
   */
  public $hl7v2Store;

  /**
   * The name of the HL7v2 store to rollback, in the format of
   * "projects/{project_id}/locations/{location_id}/datasets/{dataset_id}
   * /hl7v2Stores/{hl7v2_store_id}".
   *
   * @param string $hl7v2Store
   */
  public function setHl7v2Store($hl7v2Store)
  {
    $this->hl7v2Store = $hl7v2Store;
  }
  /**
   * @return string
   */
  public function getHl7v2Store()
  {
    return $this->hl7v2Store;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RollbackHl7V2MessagesResponse::class, 'Google_Service_CloudHealthcare_RollbackHl7V2MessagesResponse');
