<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class VolumeSnapshot extends \Google\Model
{
  /**
   * Type is not specified.
   */
  public const TYPE_SNAPSHOT_TYPE_UNSPECIFIED = 'SNAPSHOT_TYPE_UNSPECIFIED';
  /**
   * Snapshot was taken manually by user.
   */
  public const TYPE_AD_HOC = 'AD_HOC';
  /**
   * Snapshot was taken automatically as a part of a snapshot schedule.
   */
  public const TYPE_SCHEDULED = 'SCHEDULED';
  /**
   * Output only. The creation time of the snapshot.
   *
   * @var string
   */
  public $createTime;
  /**
   * The description of the snapshot.
   *
   * @var string
   */
  public $description;
  /**
   * Output only. An identifier for the snapshot, generated by the backend.
   *
   * @var string
   */
  public $id;
  /**
   * The name of the snapshot.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. The name of the volume which this snapshot belongs to.
   *
   * @var string
   */
  public $storageVolume;
  /**
   * Output only. The type of the snapshot which indicates whether it was
   * scheduled or manual/ad-hoc.
   *
   * @var string
   */
  public $type;

  /**
   * Output only. The creation time of the snapshot.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * The description of the snapshot.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Output only. An identifier for the snapshot, generated by the backend.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * The name of the snapshot.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. The name of the volume which this snapshot belongs to.
   *
   * @param string $storageVolume
   */
  public function setStorageVolume($storageVolume)
  {
    $this->storageVolume = $storageVolume;
  }
  /**
   * @return string
   */
  public function getStorageVolume()
  {
    return $this->storageVolume;
  }
  /**
   * Output only. The type of the snapshot which indicates whether it was
   * scheduled or manual/ad-hoc.
   *
   * Accepted values: SNAPSHOT_TYPE_UNSPECIFIED, AD_HOC, SCHEDULED
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VolumeSnapshot::class, 'Google_Service_Baremetalsolution_VolumeSnapshot');
