<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class NfsShare extends \Google\Collection
{
  /**
   * The share is in an unknown state.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The share has been provisioned.
   */
  public const STATE_PROVISIONED = 'PROVISIONED';
  /**
   * The NFS Share is being created.
   */
  public const STATE_CREATING = 'CREATING';
  /**
   * The NFS Share is being updated.
   */
  public const STATE_UPDATING = 'UPDATING';
  /**
   * The NFS Share has been requested to be deleted.
   */
  public const STATE_DELETING = 'DELETING';
  /**
   * The storage type for this volume is unknown.
   */
  public const STORAGE_TYPE_STORAGE_TYPE_UNSPECIFIED = 'STORAGE_TYPE_UNSPECIFIED';
  /**
   * The storage type for this volume is SSD.
   */
  public const STORAGE_TYPE_SSD = 'SSD';
  /**
   * This storage type for this volume is HDD.
   */
  public const STORAGE_TYPE_HDD = 'HDD';
  protected $collection_key = 'allowedClients';
  protected $allowedClientsType = AllowedClient::class;
  protected $allowedClientsDataType = 'array';
  /**
   * Output only. An identifier for the NFS share, generated by the backend.
   * This is the same value as nfs_share_id and will replace it in the future.
   *
   * @var string
   */
  public $id;
  /**
   * Labels as key value pairs.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Immutable. The name of the NFS share.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. An identifier for the NFS share, generated by the backend.
   * This field will be deprecated in the future, use `id` instead.
   *
   * @var string
   */
  public $nfsShareId;
  /**
   * Immutable. Pod name. Pod is an independent part of infrastructure. NFSShare
   * can only be connected to the assets (networks, instances) allocated in the
   * same pod.
   *
   * @var string
   */
  public $pod;
  /**
   * The requested size, in GiB.
   *
   * @var string
   */
  public $requestedSizeGib;
  /**
   * Output only. The state of the NFS share.
   *
   * @var string
   */
  public $state;
  /**
   * Immutable. The storage type of the underlying volume.
   *
   * @var string
   */
  public $storageType;
  /**
   * Output only. The underlying volume of the share. Created automatically
   * during provisioning.
   *
   * @var string
   */
  public $volume;

  /**
   * List of allowed access points.
   *
   * @param AllowedClient[] $allowedClients
   */
  public function setAllowedClients($allowedClients)
  {
    $this->allowedClients = $allowedClients;
  }
  /**
   * @return AllowedClient[]
   */
  public function getAllowedClients()
  {
    return $this->allowedClients;
  }
  /**
   * Output only. An identifier for the NFS share, generated by the backend.
   * This is the same value as nfs_share_id and will replace it in the future.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Labels as key value pairs.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Immutable. The name of the NFS share.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. An identifier for the NFS share, generated by the backend.
   * This field will be deprecated in the future, use `id` instead.
   *
   * @param string $nfsShareId
   */
  public function setNfsShareId($nfsShareId)
  {
    $this->nfsShareId = $nfsShareId;
  }
  /**
   * @return string
   */
  public function getNfsShareId()
  {
    return $this->nfsShareId;
  }
  /**
   * Immutable. Pod name. Pod is an independent part of infrastructure. NFSShare
   * can only be connected to the assets (networks, instances) allocated in the
   * same pod.
   *
   * @param string $pod
   */
  public function setPod($pod)
  {
    $this->pod = $pod;
  }
  /**
   * @return string
   */
  public function getPod()
  {
    return $this->pod;
  }
  /**
   * The requested size, in GiB.
   *
   * @param string $requestedSizeGib
   */
  public function setRequestedSizeGib($requestedSizeGib)
  {
    $this->requestedSizeGib = $requestedSizeGib;
  }
  /**
   * @return string
   */
  public function getRequestedSizeGib()
  {
    return $this->requestedSizeGib;
  }
  /**
   * Output only. The state of the NFS share.
   *
   * Accepted values: STATE_UNSPECIFIED, PROVISIONED, CREATING, UPDATING,
   * DELETING
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Immutable. The storage type of the underlying volume.
   *
   * Accepted values: STORAGE_TYPE_UNSPECIFIED, SSD, HDD
   *
   * @param self::STORAGE_TYPE_* $storageType
   */
  public function setStorageType($storageType)
  {
    $this->storageType = $storageType;
  }
  /**
   * @return self::STORAGE_TYPE_*
   */
  public function getStorageType()
  {
    return $this->storageType;
  }
  /**
   * Output only. The underlying volume of the share. Created automatically
   * during provisioning.
   *
   * @param string $volume
   */
  public function setVolume($volume)
  {
    $this->volume = $volume;
  }
  /**
   * @return string
   */
  public function getVolume()
  {
    return $this->volume;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NfsShare::class, 'Google_Service_Baremetalsolution_NfsShare');
