<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Analytics;

class CustomDataSourceChildLink extends \Google\Model
{
  /**
   * Link to the list of daily uploads for this custom data source. Link to the
   * list of uploads for this custom data source.
   *
   * @var string
   */
  public $href;
  /**
   * Value is "analytics#dailyUploads". Value is "analytics#uploads".
   *
   * @var string
   */
  public $type;

  /**
   * Link to the list of daily uploads for this custom data source. Link to the
   * list of uploads for this custom data source.
   *
   * @param string $href
   */
  public function setHref($href)
  {
    $this->href = $href;
  }
  /**
   * @return string
   */
  public function getHref()
  {
    return $this->href;
  }
  /**
   * Value is "analytics#dailyUploads". Value is "analytics#uploads".
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CustomDataSourceChildLink::class, 'Google_Service_Analytics_CustomDataSourceChildLink');
