<?php

$maxImageSize = setting('_general.max_image_size');

return [
    'id'        => 'clients-feedback',
    'name'      => __('Clients feedback'),
    'icon'      => '<i class="icon-users"></i>',
    'tab'       => 'Common',
    'fields'    => [
        [
            'id'            => 'section_title_variation',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Section title variation'),
            'options'       => [
                'am-section_title_one'      => __('Classic'),
                'am-section_title_two'      => __('Traditional'),
                'am-section_title_three'    => __('Modern'),
            ],
            'default'       => '',
        ],
        [
            'id'            => 'pre_heading_text_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading text color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading_bg_color',
            'type'          => 'colorpicker',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading bg color'),
            // 'field_desc'    => __('settings.pre_heading_text_color_desc'),
        ],
        [
            'id'            => 'pre_heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Pre heading'),
            'placeholder'   => __('Enter pre heading'),
        ],
        [
            'id'            => 'heading',
            'type'          => 'text',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Heading'),
            'placeholder'   => __('Enter heading'),
        ],
        [
            'id'            => 'paragraph',
            'type'          => 'editor',
            'value'         => '',
            'class'         => '',
            'label_title'   => __('Description'),
            'placeholder'   => __('Enter description'),
        ],
        [
            'id'            => 'enable_slider',
            'type'          => 'radio',
            'class'         => '',
            'label_title'   => __('Enable Slider'),
            'options'       => [
                'yes'   => __('Yes'),
                'no'    => __('No'),
            ],
            'default'       => 'no',  
        ],
        [
            'id'            => 'verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select title verient'),
            'options'       => [
                'feedback-verient-one'        => 'Verient v1',
                'feedback-verient-two'        => 'Verient v2',
                'am-feedback-verient-three'   => 'Verient v3',
            ],
            'default'       => 'non',  
            'placeholder'   => __('settings.select_from_list'),  
        ],
        [
            'id'            => 'select_title_verient',
            'type'          => 'select',
            'class'         => '',
            'label_title'   => __('Select title varient'),
            'options'       => [
                ''                            => 'Select title style',
                'am-title-varient-one'        => 'Title style v1',
            ],
            'default'       => '',  
            'placeholder'   => __('settings.select_from_list'),  
        ],
        [                                                          
            'id'                => 'feedback_repeater',
            'type'              => 'repeater',
            'label_title'       => __('Feedback data'),
            'repeater_title'    => __('Feedback data'),
            'multi'             => true,
            'fields'       => [
                [
                    'id'            => 'feedback_paragraph',
                    'type'          => 'editor',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Feedback description'),
                    'placeholder'   => __('Enter description'),
                ],
                [
                    'id'            => 'tutor_rating',
                    'type'          => 'select',
                    'class'         => '',
                    'label_title'   => __('Select rating'),
                    'options'       => [
                            '1'     => '1',
                            '2'     => '2',
                            '3'     => '3',
                            '4'     => '4',
                            '5'     => '5',
                    ],
                    'default'       => '2',  
                ],
                [
                    'id'            => 'tutor_image',
                    'type'          => 'file',
                    'class'         => '',
                    'label_title'   => __('Tutor image'),
                    'label_desc'    => __('Add image'),
                    'max_size'      => $maxImageSize ?? 5,               
                    'ext'    => [
                        'jpg',
                        'png',
                        'svg',
                        'jpeg',
                        'webp',
                    ], 
                ],
                [
                    'id'            => 'tutor_name',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Tutor name'),
                    'placeholder'   => __('Enter name'),
                ],
                [
                    'id'            => 'tutor_tagline',
                    'type'          => 'text',
                    'value'         => '',
                    'class'         => '',
                    'label_title'   => __('Tutor tagline'),
                    'placeholder'   => __('Enter tagline'),
                ],
                [
                    'id'            => 'student_image',
                    'type'          => 'file',
                    'class'         => '',
                    'label_title'   => __('Student image'),
                    'label_desc'    => __('Add image'),
                    'max_size'      => $maxImageSize ?? 5,               
                    'ext'    => [
                        'jpg',
                        'png',
                        'svg',
                        'jpeg',
                        'webp',
                    ], 
                ],
            ],
        ],
    ]
];
